﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Verse;
using Verse.AI;
using RimWorld;

namespace rjw {
    public class JobGiver_Beastiality : ThinkNode_JobGiver {

        public static Pawn find_target(Pawn pawn, Map m) {
            //Log.Message("JobGiver_Beastiality::find_corpse( " + rapist.NameStringShort + " ) called");
            Pawn found = null;
            var best_distance = 1.0e6f;

            foreach (Pawn target in m.mapPawns.AllPawns) {
                // prefer domesticated animals over wild animals
                if (xxx.is_animal(target)) {
                    float temperment = target.RaceProps.wildness / target.RaceProps.petness;
                    float distance = pawn.Position.DistanceToSquared(target.Position) * temperment;
                    if (distance < best_distance) {
                        found = target;
                        best_distance = distance;
                    }

                }
            }
       
            return found;
        }

        protected override Job TryGiveJob(Pawn p) {
            Log.Message("[RJW] JobGiver_Beastiality::TryGiveJob( " + p.NameStringShort + " ) called");
            if ((Find.TickManager.TicksGame >= p.mindState.canLovinTick) && (p.CurJob == null)) {

                if (p.health.capacities.CanBeAwake && xxx.can_fuck(p)) {
                    var target = find_target(p, p.Map);
                    Log.Message("   target = " + target + ", distance = " + p.Position.DistanceToSquared(target.Position));
                    if (target != null) {
                        return new Job(DefDatabase<JobDef>.GetNamed("Beastiality"), target);
                    }
                }
            }

            return null;
        }
    }
}
